% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{vis.net}
\alias{vis.net}
\title{Visualize a network}
\usage{
vis.net(
  df,
  m,
  col.id = NULL,
  col.size = NULL,
  color = c("black", "white"),
  col.color = NULL,
  col.shape = NULL,
  shapes = NULL,
  strokeCol = c("white", "black"),
  col.strokeCol = NULL,
  col.stroke = NULL,
  layers = NULL,
  node.opacity = NULL,
  link.opacity = FALSE,
  background = "grey"
)
}
\arguments{
\item{df}{a data frame with node information.}

\item{m}{a matrix of node connections.}

\item{col.id}{a character or numeric vector indicating the column name or index of node Ids.}

\item{col.size}{a character or numeric vector indicating the column name or index of node size.}

\item{color}{a vector character of length two indicating the range of color for node color.}

\item{col.color}{a character or numeric vector indicating the column name or index of node color.}

\item{col.shape}{a character or numeric vector indicating the column name or index of node shape.}

\item{shapes}{a character vector indicating the type of shape per category. 7 shapes are available: "circle", "cross", "diamond", "rectangle, "star", "triangle", "y"}

\item{strokeCol}{a vector character of length two indicating the range of color for node stroke color.}

\item{col.strokeCol}{a character or numeric vector indicating the column name or index of node stroke color.}

\item{col.stroke}{a character or numeric vector indicating the column name or index of node stroke.}

\item{layers}{a column in argument df indicating the factor to use for multi-layer layout.}

\item{node.opacity}{a character or numeric vector indicating the column name or index of node opacity.}

\item{link.opacity}{a character or numeric vector indicating the column name or index of link opacity.}

\item{background}{a character indicating the background color.}
}
\value{
Opens default web browser with the ploted network.
}
\description{
Plots a network
}
\details{
Opens default web browser and shows 'NetExplorer' interface with the desired network.
Further information and tutorial can be found in my video https://youtu.be/IcFTZWCTO_s/
}
\examples{
vis.net(df,m,col.id = "id", col.size = "strength",
color = c('green', 'yellow'), col.color = "age" ,
strokeCol = c('red', 'blue'), col.strokeCol = "kinship",
col.stroke = "degree",
col.shape =  "sex",shapes = c("circle", "triangle"),
layers =  "kinship")
}
\author{
Sebastian Sosa
}
