% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netint.R
\name{ATLEASTK.int}
\alias{ATLEASTK.int}
\title{ATLEASTK network integration}
\usage{
ATLEASTK.int(k = 1, ...)
}
\arguments{
\item{k}{the minimum number of the networks in which each edge must be present to
be preserved (k=1).}

\item{...}{a list of numeric matrices. These must be named matrices representing
adjacency matrices of the networks. Matrices may have different dimensions,
but corresponding elements in different matrices must have the same name.}
}
\value{
the integrated matrix : the matrix resulting from ATLEASTK.
}
\description{
It performs the ATLEAST integration between networks: only edges
present in at least k networks are preserved, the others are eliminated.
The resulting network is a binary network: the edge is 1 if preserved, otherwise 0.
An edge is considered "present" if its value is larger than 0.
}
\examples{
# Create three example networks of different size
set.seed(123);
A1 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A1[lower.tri(A1)] = t(A1)[lower.tri(A1)];
diag(A1) <- 0;
rownames(A1) <- colnames(A1) <- sample(LETTERS, 10);

A2 <- matrix(runif(49, min = 0, max = 1), nrow = 7);
A2[lower.tri(A2)] = t(A2)[lower.tri(A2)];
diag(A2) <- 0;
rownames(A2) <- colnames(A2) <- rownames(A1)[1:7];

A3 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A3[lower.tri(A3)] = t(A3)[lower.tri(A3)];
diag(A3) <- 0;
rownames(A3) <- colnames(A3) <- c(rownames(A1)[1:5], c("A", "B", "Z", "K", "Q"));

# Integrate networks using ATLEASTK method
A_int <- ATLEASTK.int(k=2, A1, A2, A3);
}
