% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdLogNormalPareto.R
\name{ILFSlicedLNormPareto}
\alias{ILFSlicedLNormPareto}
\title{Increased Limit Factor Curve from a Sliced LogNormal Pareto severity distribution}
\usage{
ILFSlicedLNormPareto(xLow, xHigh, mu, sigma, SlicePoint, shape)
}
\arguments{
\item{xLow}{A positive real number -  the claim amount where the Limit Factor Curve will be evaluated from.}

\item{xHigh}{A positive real number -  the claim amount where the Limit Factor Curve will be evaluated to.}

\item{mu}{A real number -  the first parameter of the attritional Claim Severity's LogNormal distribution.}

\item{sigma}{A positive real number -  the second parameter of the attritional Claim Severity's LogNormal distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the tail Claim Severity's Pareto distribution.}

\item{shape}{A positive real number - the shape parameter of the tail Claim Severity's Pareto distribution.}
}
\value{
The value of the Increased Limit Factor curve from \code{xLow} to \code{xHigh} with an attritional claim LogNormal distribution with parameters \code{mu} and \code{sigma} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{shape}.
}
\description{
Increased Limit Factor Curve from a Sliced LogNormal Pareto severity distribution
}
\examples{
ILFSlicedLNormPareto(800,1200,6,1.5,1000,1.2)
ILFSlicedLNormPareto(2000,4000,7,1.6,3000,1.4)
}
