% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeuralEstimators.R
\docType{package}
\name{NeuralEstimators-package}
\alias{NeuralEstimators}
\alias{NeuralEstimators-package}
\title{NeuralEstimators: Likelihood-Free Parameter Estimation using Neural Networks}
\description{
An 'R' interface to the 'Julia' package 'NeuralEstimators.jl'. The package facilitates the user-friendly development of neural Bayes estimators, which are neural networks that map data to a point summary of the posterior distribution (Sainsbury-Dale et al., 2024, \doi{10.1080/00031305.2023.2249522}). These estimators are likelihood-free and amortised, in the sense that, once the neural networks are trained on simulated data, inference from observed data can be made in a fraction of the time required by conventional approaches. The package also supports amortised Bayesian or frequentist inference using neural networks that approximate the posterior or likelihood-to-evidence ratio (Zammit-Mangion et al., 2025, Sec. 3.2, 5.2, \doi{10.48550/arXiv.2404.12484}). The package accommodates any model for which simulation is feasible by allowing users to define models implicitly through simulated data.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/msainsburydale/NeuralEstimators}
  \item \url{https://msainsburydale.github.io/NeuralEstimators.jl/dev/}
}

}
\author{
\strong{Maintainer}: Matthew Sainsbury-Dale \email{msainsburydale@gmail.com}

}
\keyword{internal}
