% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monophyly.prop.R
\name{monophyly.prop}
\alias{monophyly.prop}
\title{Calculate the proportion of monophyletic group on a tree}
\usage{
monophyly.prop(phy, sppVector, singletonsMono = TRUE)
}
\arguments{
\item{phy}{A tree of class phylo.}

\item{sppVector}{Species vector.}

\item{singletonsMono}{Logical. Should singletons (i.e. only a single
specimen representing that species) be treated as monophyletic?
Default of TRUE. Possible values of FALSE and NA.}
}
\value{
A list containing proportion and number of monophyly group.

A set monophyly and of non-monophyly group names.
}
\description{
Calculate the proportion of monophyletic group on a tree given
species vector and a tree.
}
\examples{
library(ape)
tree<-ape::rtree(20)
tree$tip.label<-sample(tree$tip.label[1:10],size=20,replace = TRUE)
plot(tree)
sppVector<-tree$tip.label

MP<-monophyly.prop(tree,sppVector,singletonsMono = TRUE)
MP
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{monophyly.prop}
