% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoviceDeveloperResources.R
\name{checkBuildInstallSourcePackage}
\alias{checkBuildInstallSourcePackage}
\title{checkBuildInstallSourcePackage}
\usage{
checkBuildInstallSourcePackage(dir, packs, packCheck, autoLibrary = FALSE)
}
\arguments{
\item{dir}{character string containing the path name of the directory holding the package folders}

\item{packs}{character vector of the names of the packages}

\item{packCheck}{character vector of the names of the packages to check()}

\item{autoLibrary}{Boolean if TRUE automate library() command altering search path}
}
\value{
returns a list whose components are
\itemize{
\item
character string that can be printed using "echo" and then
copy and paste by the user to load or update the packages
\item
return value of dateTable()
}
}
\description{
check, build, and install local source package
}
\details{
I wanted to include "library(packs)" in the program, but this is not allowed.
The user can "cat" the return value and copy and paste to facilitate doing
this manually.
}
\examples{
\dontrun{
# you need to specify dir, packs that are on your own computer !!
dir1<-"~/personal/hearts/hearts_card_game_bayesian_inference"
dir2<-"packages/inference_packages/inference_packages/"
packs<-c("cardUtils","clickableImageMap")
l<-checkBuildInstallSourcePackage(sprintf("\%s/\%s",dir1,dir2),packs,packs,TRUE)
}

}
