% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RotMat.R
\name{RotMatRand}
\alias{RotMatRand}
\title{Random Rotation Matrix}
\usage{
RotMatRand(
  dimX,
  randDist = "Binary",
  numProj = ceiling(sqrt(dimX)),
  dimProj = "Rand",
  sparsity = ifelse(dimX >= 10, 3/dimX, 1/dimX),
  prob = 0.5,
  lambda = 1,
  catLabel = NULL,
  ...
)
}
\arguments{
\item{dimX}{The number of dimensions.}

\item{randDist}{The probability distribution of the random projection direction, including "Binary": \eqn{B\{-1,1\}} binomial distribution (default),
"Norm":\eqn{N(0,1)} normal distribution, "Uniform": \eqn{U(-1,1)} uniform distribution.}

\item{numProj}{The number of projection directions (default ceiling(sqrt(\code{dimX}))).}

\item{dimProj}{Number of variables to be projected, default dimProj="Rand": random from 1 to \code{dimX}.}

\item{sparsity}{A real number in \eqn{(0,1)} that specifies the distribution of non-zero elements in the random matrix.
When sparsity="pois" means that non-zero elements are generated by the p(\code{lambda}) Poisson distribution.}

\item{prob}{A probability in \eqn{(0,1)} used for sampling from \eqn{{-1,1}} where \code{prob = 0} will only sample -1 and \code{prob = 1} will only sample 1.}

\item{lambda}{Parameter of the Poisson distribution (default 1).}

\item{catLabel}{A category labels of class \code{list} in predictors. (default NULL, for details see Examples of \code{\link{ODT}})}

\item{...}{Used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{ODT}}.
\itemize{
\item{Variable: Variables to be projected.}
\item{Number: Number of projections.}
\item{Coefficient: Coefficients of the projection matrix.}
}
}
\description{
Generate rotation matrices by different distributions, and it comes from the library \code{rerf}.
}
\examples{
set.seed(1)
paramList <- list(dimX = 8, numProj = 3, sparsity = 0.25, prob = 0.5)
(RotMat <- do.call(RotMatRand, paramList))
paramList <- list(dimX = 8, numProj = 3, sparsity = "pois")
(RotMat <- do.call(RotMatRand, paramList))
paramList <- list(dimX = 8, randDist = "Norm", dimProj = 5)
(RotMat <- do.call(RotMatRand, paramList))

}
\references{
Tomita, T. M., Browne, J., Shen, C., Chung, J., Patsolic, J. L., Falk, B., ... & Vogelstein, J. T. (2020). Sparse projection oblique randomer forests. Journal of machine learning research, 21(104).
}
\seealso{
\code{\link{RotMatPPO}} \code{\link{RotMatRF}} \code{\link{RotMatMake}}
}
\keyword{rotation}
