% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confBands.OEFPIL.R
\name{confBands.OEFPIL}
\alias{confBands.OEFPIL}
\alias{confBands}
\title{Confidence and prediction bands for OEFPIL object}
\usage{
## S3 method for class 'OEFPIL'
   confBands(object, xx, signif.level = 0.05, new.obs.variance)
}
\arguments{
\item{object}{an object of class \code{"OEFPIL"} (a result of a call to \code{\link{OEFPIL}}).}

\item{xx}{a sequence of x-coordinates of points for computing confidence and prediction intervals. If missing, the default sequence \code{seq(from = min(x), to = max(x), length.out = 301)} is used.}

\item{signif.level}{a numerical value or a vector of significance levels for confidence bands. If missing, the default value 0.05 is used.}

\item{new.obs.variance}{the variance of a new observation for prediction interval computing.}
}
\value{
Returns an object of type list containing the following components.

\item{xx}{a numerical vector of points where intervals are calculated.}
\item{yy}{a numerical vector with values of estimated function in \code{xx}.}
\item{PointwiseCB}{a matrix of confidence intervals at points \code{xx}.}
\item{PredictCB}{a matrix of prediction intervals at points \code{xx}.}
}
\description{
Function calculates pointwise confidence bands and prediction bands of estimated function from an object of class \code{"OEFPIL"}.
}
\details{
An argument \code{signif.level} can be one numerical value or vector of numerical values of significance levels for confidence intervals.

If \code{new.obs.variance} is not defined by user, the average variance in the dependent variable is used to compute prediction intervals.
}
\examples{
\dontshow{
utils::example("coef.OEFPIL",echo=FALSE)}
##-- Continuing the coef.OEFPIL(.) example:

##Use of confBands function with default parameters
a <- confBands(st1)
str(a)

##Computing two different confidence bands in one step
b <- confBands(st1, signif.level = c(0.01,0.05))
str(b)

}
\seealso{
\code{\link{OEFPIL}}, \code{\link{plot.OEFPIL}}
}
