% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbc_lm.R
\name{plot.cbc_lm}
\alias{plot.cbc_lm}
\title{Plot Method for 'cbc_lm' Objects}
\usage{
\method{plot}{cbc_lm}(x, n_models = length(x$models), ask = interactive() && n_models > 1, ...)
}
\arguments{
\item{x}{A 'cbc_lm' object.}

\item{n_models}{The number of models to plot. Defaults to the total number of
models in 'x'. If 'n_models' is greater than the number of models available,
a warning will be issued and all models will be plotted.}

\item{ask}{Logical. If TRUE (and the session is interactive), the function will
prompt the user before displaying the next plot. Defaults to TRUE when the session
is interactive and there is more than one model to be plotted.}

\item{...}{Additional graphical parameters to pass to the plot function.}
}
\value{
The function is used for its side effect of generating diagnostic plots. It
invisibly returns the 'cbc_lm' object.
}
\description{
This function generates diagnostic plots for each linear model included in a
'cbc_lm' object. By default, it plots all models but this can be controlled by
specifying the 'n_models' parameter. If multiple plots are to be generated,
the function can be set up to ask before displaying the next plot (if the
session is interactive).
}
\seealso{
\code{\link{cbc_lm}}
}
