% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbc_lm.R
\name{summary.cbc_lm}
\alias{summary.cbc_lm}
\title{Summary Method for 'cbc_lm' Objects}
\usage{
\method{summary}{cbc_lm}(
  object,
  digits = max(3L, getOption("digits") - 3L),
  boot = FALSE,
  n_models = length(object$models),
  ...
)
}
\arguments{
\item{object}{A 'cbc_lm' object.}

\item{digits}{The number of significant digits to use when printing.}

\item{boot}{Logical indicating whether or not to include the bootstrap mean
coefficients in the summary.}

\item{n_models}{The number of models to include in the summary. Defaults to
all models.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class 'summary.cbc_lm', which includes the call,
the mean coefficients, (optionally) the bootstrap mean coefficients,
standard errors, confidence intervals, and a summary of the models.
}
\description{
Summary method for 'cbc_lm' objects. Returns the mean coefficients,
bootstrap mean coefficients, standard errors, and confidence intervals, as
well as a summary of the models.
}
\seealso{
\code{\link{print.cbc_lm}}, \code{\link{plot.cbc_lm}}
}
