% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.Groupwise}
\alias{print.Groupwise}
\title{Prints all details about a Groupwise object.}
\usage{
\method{print}{Groupwise}(x, printSizes = length(x), ...)
}
\arguments{
\item{x}{A Groupwise object as it is returned by \code{\link{groupwise}}-function.}

\item{printSizes}{Integer that specifies how many of the cascade sizes (starting with the largest cascades) 
should be printed.}

\item{...}{Further parameters}
}
\description{
Prints all details about a Groupwise object.
}
\details{
Prints all details about a given Groupwise object. 
A Groupwise object re-sorts a Subcascades object 
in a way that the cascades made up of the same classes are grouped. 
The printSizes parameter can be used to control the cascade sizes to be printed.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

# generate Subcascades object
subc = subcascades(predMap,thresh=0.7)

#create a Groupwise object
groupwise = groupwise(subc)

print(groupwise, printSizes = 2)
}
