% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSNMTF.R
\name{OSNMTF}
\alias{OSNMTF}
\title{The algorithm OSNMTF}
\usage{
OSNMTF(W,lambda=0.2,theta=10^-4,k,l)
}
\arguments{
\item{W}{The matrix to be factorized}

\item{lambda}{A parameter to set the relative weight of the sparsity constraints}

\item{theta}{A parameter to determine the convergence}

\item{k}{A parameter to specify the row cluster number}

\item{l}{A parameter to specify the column cluster number}
}
\value{
A list containing the clustering result
\item{sub_matrices}{a list containing the matrix L, C, R}

\item{cluster_results}{a list containing the row cluster results and the column cluster results}
}
\description{
Factorize matrix W into the multiplication of L, C and R, with L and R being orthogonal and C being sparse. Then the row cluster results and column cluster results are obtained from L and R.
}
\examples{

W <- simu_data_generation()
OSNMTF_res <- OSNMTF(W,k=5,l=4)
}
\author{
Xiaoyao Yin
}
