% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Gini2}
\alias{Gini2}
\title{A function to compute the between group version of segregation Gini index}
\usage{
Gini2(x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
A matrix containing the between-group Gini index values for 
each pair of groups
}
\description{
The between group version of Gini index is obtained 
by computing the index for a subpopulation formed by each pair of groups
}
\examples{
x <- segdata@data[ ,1:2]
Gini2(x)
}
\references{
Duncan O. D. and Duncan B. (1955) \emph{A Methodological 
Analysis of Segregation Indexes}. American Sociological Review 41, 
pp. 210-217

Tivadar M. (2019) 
\emph{OasisR: An R Package to Bring Some Order to the World of Segregation Measurement}.
Journal of Statistical Software,  89 (7), pp 1-39
}
\seealso{
Other one-group  evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Gini}}, 
\code{\link{Gorard}}, \code{\link{Atkinson}}, 
\code{\link{HTheil}}, '\code{\link{ISWong}}, \code{\link{ISMorrill}},
\code{\link{ISMorrillK}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{DIMorrill}}, 
\code{\link{DIMorrillK}}, \code{\link{DIWong}}
}
