% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ISimpson}
\alias{ISimpson}
\title{A function to compute Simpson's interaction index}
\usage{
ISimpson(x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
The Simpson's interaction index value (numeric)
}
\description{
Simpson's interaction index measures the probability 
that randomly selected individuals are not in the same group.
}
\examples{
x <- segdata@data[ ,1:2]
ISimpson(x) 
}
\references{
Simpson E. H. (1949) \emph{Measurement of diversity}. 
Nature 163:688
}
\seealso{
Social diversity indices: 
\code{\link{HShannon}}, \code{\link{NShannon}},

multigroup indices: 
\code{\link{PMulti}}, \code{\link{GiniMulti}}, \code{\link{DMulti}},  
\code{\link{HMulti}}, \code{\link{CMulti}}, \code{\link{RelDivers}}
}
