.First.lib <- function(library, pkg)
{	
  library.dynam("sm", pkg, library)
  assign(".sm.home", paste(library, pkg, sep="/"), envir = .GlobalEnv)
  cat("Library `sm'; Copyright (C) 1997 A.W.Bowman & A.Azzalini\n")
  cat("See `Licence' for details and conditions for use\n")
  invisible()
}

if(version$major==0 && version$minor < 63.3) {
  jitter <- function(x, factor = 1, amount=NULL)
  {
    z <- diff(r <- range(x[is.finite(x)]))
    if(z == 0) z <- abs(r[1])
    if(z == 0) z <- 1

    if(is.null(amount)) {               # default: Find 'necessary' amount
      d <- diff(xx <- unique(sort(round(x, 3 - floor(log10(z))))))
      d <- if(length(d)) min(d) else if(xx!=0) xx/10 else z/10
      amount <- factor/5 * d
    } else if(amount == 0)              # only then: S compatibility
      amount <- factor * (z/50)

    x + runif(length(x),  - amount, amount)
  }
  invisible()
}

isMatrix <- function (x) length(dim(x)) == 2

smchull <- function(x, y=NULL)
{
  X <- xy.coords(x, y, recycle = TRUE)
  x <- cbind(X$x, X$y)
  n <- nrow(x)
  z <- .Fortran("smchull",
                n=as.integer(n),
                as.double(t(x)),
                as.integer(n),
                as.integer(1:n),
                integer(n),
                integer(n),
                ih=integer(n),
                nh=integer(1),
                il=integer(n))
  rev(z$ih[1:z$nh])
}

sm.script <- function(name, path) 
{
  if (missing(path)) 
    path <- paste(.sm.home, "scripts", sep = "/")
  else path <- as.character(substitute(path))
  if (missing(name)) {
    indexfile <- paste(path, "Index.doc", sep = "/")
    pager <- options("pager")$pager
    system(paste(pager, indexfile))
  } else {
    name <- as.character(substitute(name))
    if(length(name) == 3 && name[1] == "<-")
      name <- paste(name[2:3], collapse="_")
    source(paste(path, "/", name, ".q", sep = ""))
  }
  invisible()
}
