% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmegaG.R
\name{OmegaG}
\alias{OmegaG}
\title{Composite Reliability Coefficient Omega-Generic}
\usage{
OmegaG(
  Lambda = NULL,
  Phi = NULL,
  Psi = NULL,
  items.index = NULL,
  factor.index = NULL,
  scale.structure = NULL,
  modeltype = c("correlated-factor", "bi-factor")
)
}
\arguments{
\item{Lambda}{The input factor lading matrix. Each row contains the loadings of one item on factors. Each column includes the loadings of one factor. In the case of bi-factor structure, the first column of loadings is on the global factor.}

\item{Phi}{The input factor covariance matrix.}

\item{Psi}{The input covariance matrix of item residuals. Typically, \code{Psi} is a diagonal matrix.}

\item{items.index}{The vector indexing the items of which the composite reliability is being estimated. It is an optional argument. If it is specified, the argument \code{scale.structure} is not effective. If it is not specified, the the argument \code{scale.structure} is expected to be specified and effective.}

\item{factor.index}{The vector indexing the factor(s)/construct(s) regarding which the composite reliability is being estimated. It is an optional argument. If it is not specified, the function will estimate the composite reliability regarding each factor/construct.}

\item{scale.structure}{The scale structure in a list or a Boolean matrix form. In a list form, each element is a vector of items (names) of a subscale. If in a boolean form, the element on the i-th row and the j-th column indicates whether the i-th item is within the j-th subscale. If both the argument \code{scale.structure} and \code{Lambda} include colnames and rownames, the names must be match with each other. This argument \code{scale.structure} is optional. Only when \code{item-index} is not specified, this argument is effective.}

\item{modeltype}{The type of factor structure (\code{"corr-factor"} or \code{"bi-factor"}). The current version supports correlated-factor structure and bi-factor structure. A bi-factor model typically assumes factors are uncorrelated. The default is correlated-factor structure.}
}
\value{
The estimated composite reliability coefficient OmegaG.
}
\description{
This function is used to estimate the composite reliability coefficient Omega-generic (\cite{Mai, Srivastava, & Krull, 2021}), given factor loadings, factor covariance matrix, and covariance matrix of item residuals.
}
\examples{
\dontshow{
 #Toy example for check:
 Lambda <- cbind(c(0.7,0.65, 0.5, 0.0, 0.05, 0.15),
                 c(0.10, 0.05, 0.21, 0.72, 0.70, 0.65),
                 c(0.5, 0.6, 0.71, 0.65, 0.4, 0.5))
 Phi <- diag(rep(1,3))
 Psi <- diag(c(0.2500, 0.2150, 0.2018, 0.0591, 0.3475, 0.3050))
 varname <- paste('y',1:6,sep=''); factorname <- c(paste('fs',1:2,sep=''),'fg')
 colnames(Lambda) <- factorname; rownames(Lambda)<-varname;
 colnames(Phi)<-rownames(Phi)<-factorname; colnames(Psi)<-rownames(Psi)<-varname

 OmegaG(Lambda, Phi, Psi,
      scale.structure = cbind(c(rep(TRUE,3),rep(FALSE,3)),
                              c(rep(FALSE,3), rep(TRUE,3))),
      modeltype='bi-factor')
# Omegaesem.s1  Omegaesem.s2 Omegaesem.hs1 Omegaesem.hs2  Omegaesem.hg
# 0.8950369     0.8303052     0.4107981     0.3055959     0.6024197


OmegaG(Lambda, Phi, Psi,items.index=1:3,factor.index=1,
      scale.structure = cbind(c(rep(TRUE,3),rep(FALSE,3)),
                              c(rep(FALSE,3), rep(TRUE,3))),
      modeltype='bi-factor')
OmegaG(Lambda, Phi, Psi,items.index=1:3,factor.index=1)
}
\donttest{
#### Example 1:
OmegaG(Lambda = PedsQLMFS$ESEM$Lambda,
                       Phi = PedsQLMFS$ESEM$Phi,
                        Psi = PedsQLMFS$ESEM$Psi,
                        modeltype = "correlated-factor",
                        scale.structure = PedsQLMFS$ScaleStructure
                        )

#  Model type = correlated-factor
#
#  CR of each subscale:
#       GeneralFatigue :    0.770
#         SleepFatigue :    0.690
#     CognitiveFatigue :    0.777


#### Example 2:
 OmegaG(Lambda = PedsQLMFS$biESEM$Lambda,
                Phi = PedsQLMFS$biESEM$Phi,
                Psi = PedsQLMFS$biESEM$Psi,
                modeltype = "bi-factor",
                scale.structure = PedsQLMFS$ScaleStructure
 )

# Model type = bi-factor
#
# Hierarchy and Hierarchical-subscale CR:
#                          GlobalFatigue :    0.806
#                         GeneralFatigue :    0.174
#                           SleepFatigue :    0.361
#                       CognitiveFatigue :    0.190
#
# Scale Total and Subscale CR:
#   GlobalFatigue + all sepcific factors :    0.926
#         GlobalFatigue + GeneralFatigue :    0.859
#           GlobalFatigue + SleepFatigue :    0.758
#       GlobalFatigue + CognitiveFatigue :    0.839


# Example 3:
 OmegaG::OmegaG(Lambda = PedsQLMFS$biESEM$Lambda,
       Phi = PedsQLMFS$biESEM$Phi,
       Psi = PedsQLMFS$biESEM$Psi,
       modeltype = "bi-factor",
       items.index = 1:6,factor.index = 2
 )

# Model type = bi-factor
#
# CR of Items 1 2 3 4 5 6 regarding factor 2:
#                      GeneralFatigue :    0.174


# Example 4:
  OmegaG::OmegaG(Lambda = PedsQLMFS$ESEM$Lambda,
                 Phi = PedsQLMFS$ESEM$Phi,
                  Psi = PedsQLMFS$ESEM$Psi,
                 modeltype = "correlated-factor",
                  items.index = 7:12,factor.index = 2
   )

# Model type = correlated-factor
#
# CR of Items 7 8 9 10 11 12 regarding factor 2:
#   SleepFatigue :    0.690

}

}
\references{
Mai, Y., Srivastava, D.K., & Krull, K.R. (2021). Estimating Composite reliability of Multidimensional Measurement with Overlapping Items. Present at the 2021 Eastern North American Region (ENAR) Spring Virtual Meeting.
}
\author{
Yujiao Mai, Deo Kumar Srivastava, and Kevin R Krull
}
