% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{OvarianCancer_df}
\alias{OvarianCancer_df}
\title{Ovarian Cancer Survival Data}
\format{
A data frame with 26 observations and 6 variables:
\describe{
  \item{futime}{Follow-up time in days (numeric).}
  \item{fustat}{Survival status: 1 = deceased, 0 = alive (numeric).}
  \item{age}{Age of the patient in years (numeric).}
  \item{resid.ds}{Residual disease: size of the largest residual tumor in centimeters (numeric).}
  \item{rx}{Treatment group: 1 = standard treatment, 2 = experimental treatment (numeric).}
  \item{ecog.ps}{ECOG performance status score: 0 = fully active, 1 = restricted activity, 2 = unable to carry out work activities (numeric).}
}
}
\source{
Data taken from the survival package.
}
\usage{
data(OvarianCancer_df)
}
\description{
This dataset, OvarianCancer_df, is a data frame containing survival data from a randomized trial comparing two treatments for ovarian cancer. It includes 26 observations and 6 variables related to patient demographics, treatment, and survival outcomes.
}
\details{
The dataset name has been kept as 'OvarianCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
