% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2.TTE_052520231531.r
\name{phase2.TTE}
\alias{phase2.TTE}
\title{Two-Stage Designs with TTE Outcomes Using the One-Sample Log-Rank
Test}
\usage{
phase2.TTE(
  shape,
  S0,
  x0,
  hr,
  tf,
  rate,
  alpha,
  beta,
  prStop = 0,
  q_value = 0.5,
  dfc1 = 0.001,
  dfc2 = 0.001,
  dfc3 = 0.001,
  maxEn = 10000,
  range = 1,
  t1_p1 = 0.2,
  t1_p2 = 1.2,
  c1_p = 0.25,
  nbpt_p = 11,
  pascote_p = 1.26,
  restricted = 0
)
}
\arguments{
\item{shape}{shape parameter for the baseline hazard function assuming
that the failure time follows a Weibull distribution.}

\item{S0}{survival probability at the fixed time point x0 under the null
hypothesis (i.e, H0).}

\item{x0}{a fixed time point where the survival probability is S0 under
the null.}

\item{hr}{hazard ratio, hr < 1. s1=s0^hr, where s1 is the survival
probability under the alternative hypothesis (i.e., HA) and s0 is that
under H0.}

\item{tf}{the follow-up time (restricted or unrestricted), the time period
from the entry of the last patient to the end of the trial.}

\item{rate}{a constant accrual rate. Please consider use a reasonable rate
value. If the rate is too small, the function might throw an error.}

\item{alpha}{type I error.}

\item{beta}{type II error.}

\item{prStop}{the lower limit of the early stopping probability under H0,
with default=0.}

\item{q_value}{the relative importance between the maximum sample size (n)
and the expected sample size under H0 (ES) when deriving the design
based on the admissible method. The default is 0.5 and the range is
(0, 1). The smaller q_value is, the more importance is given to ES. The
greater it is, the more importance is given to n.}

\item{dfc1}{the value defines the stopping criterion of the optimization
process in the minmax method with smaller values lead to more iterations,
default=0.001. Change is not recommended.}

\item{dfc2}{the value defines the stopping criterion of the optimization
process in the optimal method, smaller values lead to more iterations,
default=0.001. Change is not recommended.}

\item{dfc3}{the value defines the stopping criterion of the optimization
process in the admissible method, smaller values lead to more iterations,
default=0.001. Change is not recommended.}

\item{maxEn}{the maximum of the expected sample size under null, default=
10000. Change is not recommended.}

\item{range}{the value defines how far the parameters can deviate from the
last iteration in the computation of the second-stage design parameters,
default=1. Change is not recommended.}

\item{t1_p1}{this value defines the lower limit of the possible range of t1
depending on the single-stage accrual time, default=0.2. Change is not
recommended.}

\item{t1_p2}{this value defines the upper limit of the possible range of t1
depending on the single-stage accrual time, default=0.2. Change is not
recommended.}

\item{c1_p}{this value defines the initial center in the possible range of
c1, default=0.25. Change is not recommended.}

\item{nbpt_p}{this value defines the initial number of points checked
within possible ranges for n, t1 and c1, default=11. Change is not
recommended.}

\item{pascote_p}{this value defines how fast the possible ranges of the
two-stage design parameters shrink on each iteration, default=1.26. Change
is not recommended.}

\item{restricted}{whether using restricted (1) or unrestricted (0)
follow-up, default = 0.}
}
\value{
The function returns a list that includes \bold{Single_stage},
\bold{Two_stage_Optimal}, \bold{Two_stage_minmax}, and
\bold{Two_stage_Admissible}, etc.

\bold{Single_stage} contains the design parameters for the
single-stage design:
\itemize{
\item \emph{nsignle} the required sample size for the
single-stage design.\cr
\item \emph{tasingle} the estimated accrual time for the single-stage
design.\cr
\item \emph{csingle} the critical value for the
single-stage design.\cr
}

\bold{Two_stage_Optimal} contains the design parameters for the
two-stage design based on the optimal method (i.e., minimizing ES):\cr
\itemize{
\item \emph{n1} and \emph{n} required sample sizes in the two-stage
design by the interim and final stage, respectively.\cr
\item \emph{c1} and \emph{c} critical values in the two-stage
design for interim and final analysis, respectively.\cr
\item \emph{t1} the interim analysis time in the two-stage design.\cr
\item \emph{MTSL} the maximum total study length (the sum of the accrual
time and the follow-up time).\cr
\item \emph{ES} the expected sample size under null in the two-stage
design.\cr
\item \emph{PS} the probability of early stopping under null in the
two-stage design.
}

\bold{Two_stage_minmax} contains the design parameters for the two-
stage design based on the minmax method (i.e., minimizing the total sample
size, n), including the same parameters as for the optimal method.

\bold{Two_stage_Admissible} contains the design parameters for the
two-stage design based on the admissible method (i.e., a "compromise"
between the optimal and the minmax method), including the same parameters
as for the optimal method, as well as:\cr
\itemize{
\item \emph{Rho} The expected loss. Between the total sample size n
derived from the minmax and the optimal method, the admissible
method calculates a design for each possible value of n. The design
with the lowest Rho value (i.e., first row in the output) is the
recommended design based on the admissible method with the
specified q-value.\cr
}
\bold{Other outputs}:\cr
\itemize{
\item \emph{param} The input values to the arguments.\cr
\item \emph{difn_opSg} The difference in n between the single-stage
design and the optimal two-stage designs.\cr
\item \emph{difn_opminmax} The difference in n between the optimal
and the minmax two-stage designs.\cr
\item \emph{minmax.err} 0 or 1. If minmax.err=1, optimization
for the minmax method is incomplete.\cr
\item \emph{optimal.err} 0 or 1. If optimal.err=1, optimization for
the optimal method is incomplete.\cr
\item \emph{admiss.err} 0 or 1. If admiss.err=1, optimization for
a given n value in the admissible method is incomplete.\cr
\item \emph{admiss.null1} 0 or 1. If admiss.null1=1, the
admissible result is unavailable due to incomplete optimization
with either the minmax or the optimal method.\cr
\item \emph{admiss.null2} 0 or 1. If admiss.null2=1, the
admissible result is unavailable as either the minmax or the
optimal result is unavailable.\cr
\item \emph{admiss.null3} 0 or 1. If admiss.null3=1, the admissible
result is unavailable as n in the minmax result and n in the
optimal result are equal.
}
}
\description{
phase2.TTE() provides the clinical trial design solutions for two-stage
trials with time-to-event outcomes based on the one-sample log-rank (OSLR)
test. It calculates the design parameters (e.g., t1, n1, n, c1, c) using
optimal, minmax and admissible methods.
}
\examples{
# 1. An example when q_value=0.1, i.e, more importance is given to ES.
# phase2.TTE(shape=0.5, S0=0.6, x0=3, hr=0.5, tf=1, rate=5,
# 					 alpha=0.05, beta=0.15, q_value=0.1, prStop=0, restricted=0)
# $param
#   shape  S0  hr alpha beta rate x0 tf q_value prStop restricted
# 1   0.5 0.6 0.5  0.05 0.15    5  3  1     0.1      0          0
#
# $Single_stage
#   nsingle tasingle  csingle
# 1      45        9 1.644854
#
# $Two_stage_Optimal
#   n1     c1  n      c     t1 MTSL    ES     PS
# 1 29 0.1389 48 1.6159 5.7421 10.6 37.29 0.5552
#
# $Two_stage_minmax
#   n1     c1  n      c     t1 MTSL      ES     PS
# 1 34 0.1151 45 1.6391 6.7952   10 38.9831 0.5458
#
# $Two_stage_Admissible
#      n1      c1  n      c     t1 MTSL      ES     PS      Rho
# 123  29  0.0705 47 1.6232 5.7261 10.4 37.2993 0.5281 38.26937
# 285  28  0.0792 48 1.6171 5.5663 10.6 37.2790 0.5316 38.35110
# 1701 31  0.0733 46 1.6293 6.0191 10.2 37.5828 0.5292 38.42452
# 170  33 -0.0405 45 1.6391 6.4245 10.0 38.7692 0.4839 39.39228
#
# $difn_opSg
# [1] 3
#
# $difn_opminmax
# [1] 3
#
# $minmax.err
# [1] 0
#
# $optimal.err
# [1] 0
#
# $admiss.err
# [1] 0
#
# $admiss.null1
# [1] 0
#
# $admiss.null2
# [1] 0
#
# $admiss.null3
# [1] 0

# 2. An example when q_value=0.75, i.e., more importance is given to n.
# phase2.TTE(shape=0.5, S0=0.6, x0=3, hr=0.5, tf=1, rate=5,
# alpha=0.05, beta=0.15, q_value=0.75, prStop=0, restricted=0)
# $param
#   shape  S0  hr alpha beta rate x0 tf q_value prStop restricted
# 1   0.5 0.6 0.5  0.05 0.15    5  3  1    0.75      0          0
#
# $Single_stage
#   nsingle tasingle  csingle
# 1      45        9 1.644854
#
# $Two_stage_Optimal
#   n1     c1  n      c     t1 MTSL    ES     PS
# 1 29 0.1389 48 1.6159 5.7421 10.6 37.29 0.5552
#
# $Two_stage_minmax
#   n1     c1  n      c     t1 MTSL      ES     PS
# 1 34 0.1151 45 1.6391 6.7952   10 38.9831 0.5458
#
# $Two_stage_Admissible
#      n1      c1  n      c     t1 MTSL      ES     PS      Rho
# 170  33 -0.0405 45 1.6391 6.4245 10.0 38.7692 0.4839 43.44230
# 1701 31  0.0733 46 1.6293 6.0191 10.2 37.5828 0.5292 43.89570
# 123  29  0.0705 47 1.6232 5.7261 10.4 37.2993 0.5281 44.57483
# 285  28  0.0792 48 1.6171 5.5663 10.6 37.2790 0.5316 45.31975
#
# $difn_opSg
# [1] 3
#
# $difn_opminmax
# [1] 3
#
# $minmax.err
# [1] 0
#
# $optimal.err
# [1] 0
#
# $admiss.err
# [1] 0
#
# $admiss.null1
# [1] 0
#
# $admiss.null2
# [1] 0
#
# $admiss.null3
# [1] 0
}
\references{
Wu, J, Chen L, Wei J, Weiss H, Chauhan A. (2020). Two-stage phase II survival trial design. Pharmaceutical Statistics. 2020;19:214-229. https://doi.org/10.1002/pst.1983
}
