% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{indexBieri}
\alias{indexBieri}
\title{Bieri's index of cognitive complexity}
\usage{
indexBieri(x, deviation = 0)
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{deviation}{Maximal difference between ratings to be considered a match (default \code{0} = identical scores for a
match).}
}
\value{
List of class \code{indexBieri}:
\itemize{
\item \code{grid}: The grid used to calculate the index
\item \code{deviation} The deviation parameter.
\item \code{matches_max} Maximum possible number of matches across constructs.
\item \code{matches} Total number of matches across constructs.
\item \code{constructs}: Matrix with no. of matches for constructs.
\item \code{bieri}: Bieri index (= matches / matches_max)
}
}
\description{
The index builds on the number of rating matches between pairs of constructs. It is the relation between the total
number of matches and the possible number of matches.
}
\details{
\strong{CAVEAT}: The Bieri index will change when constructs are reversed.
}
\examples{
m <- indexBieri(boeker)

# several output options
print(m)
print(m, output = "IC")  # construct matches

# extract the matrix of matches
m$constructs

# CAVEAT: Bieri's index changes when constructs are reversed
nr <- nrow(boeker)
l <- replicate(1000, swapPoles(boeker, sample(nr, sample(nr, 1))))
bieri <- sapply(l, function(x) indexBieri(x)$bieri)
hist(bieri, breaks = 50)
abline(v = mean(bieri), col = "red", lty = 2)

}
