% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_aspre.R
\name{sim_random_aspre}
\alias{sim_random_aspre}
\title{Simulate random dataset similar to ASPRE training data}
\usage{
sim_random_aspre(n, params = NULL)
}
\arguments{
\item{n}{size of population}

\item{params}{list of parameters}
}
\value{
Matrix of samples
}
\description{
Generate random population of individuals (e.g., newly pregnant women) with given population parameters

Assumes independence of parameter variation. This is not a realistic assumption, but is satisfactory for our purposes.
}
\examples{

# Load ASPRE related data
data(params_aspre)

X=sim_random_aspre(1000,params_aspre)

print(c(median(X$age),params_aspre$age$median))

print(rbind(table(X$parity)/1000,params_aspre$parity$freq))

}
\keyword{aspre}
