% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_create_burneable_mask_corine.R
\name{generate_burnable_mask}
\alias{generate_burnable_mask}
\title{Generate Burnable Mask from CORINE Rasters}
\usage{
generate_burnable_mask(
  corine_rasters,
  peninsula_shapefile,
  output_raster_dir,
  output_vector_dir,
  gdalwarp_path,
  python_exe,
  gdal_polygonize_script,
  reproject = TRUE,
  res = 90,
  to_wgs84 = TRUE,
  vectorize = TRUE
)
}
\arguments{
\item{corine_rasters}{Named list of CORINE raster file paths (e.g., one per year).}

\item{peninsula_shapefile}{Path to the Iberian Peninsula shapefile used to mask the extent.}

\item{output_raster_dir}{Directory where binary and class rasters will be written.}

\item{output_vector_dir}{Directory where vector shapefiles will be saved (if `vectorize = TRUE`).}

\item{gdalwarp_path}{Full path to the GDAL `gdalwarp` executable.}

\item{python_exe}{Full path to the Python executable.}

\item{gdal_polygonize_script}{Full path to `gdal_polygonize.py`.}

\item{reproject}{Logical. Whether to reproject rasters to EPSG:3035. Default is TRUE.}

\item{res}{Numeric. Output resolution in meters (used when reprojecting). Default is 90.}

\item{to_wgs84}{Logical. If TRUE, generates an additional raster version reprojected to EPSG:4326.}

\item{vectorize}{Logical. Whether to convert the reclassified raster to polygon shapefile. Default is TRUE.}
}
\value{
No R object is returned, but the following files are written:
- Binary raster mask (`burneable_mask_binary_<year>_ETRS89.tif`)
- Optional EPSG:4326 version (`..._wgs84.tif`)
- Multiclass raster with selected CORINE codes (`burneable_classes_def1_<year>_ETRS89.tif`)
- Polygon shapefile with selected CORINE classes (`burneable_classes_def1_<year>_ETRS89.shp`)
}
\description{
This function reclassifies CORINE land cover rasters into binary burnable masks using a predefined set of vegetation-related land cover classes.
It masks the rasters using an Iberian Peninsula shapefile, optionally reprojects them to EPSG:3035 and/or EPSG:4326, and polygonizes the result using GDAL tools.
The raster masks can be used in GEE for masking the Landsat composites.

The reclassification uses the following CORINE classes (corine_code / description):
- 244: Agro-forestry areas (22)
- 311: Broad-leaved forest (23)
- 312: Coniferous forest (24)
- 313: Mixed forest (25)
- 321: Natural grasslands (26)
- 322: Moors and heathland (27)
- 323: Sclerophyllous vegetation (28)
- 324: Transitional woodland-shrub (29)
- 333: Sparsely vegetated areas (32)
- 334: Burnt areas (33)

These classes are assigned a gridcode from 22 to 33 in the final output shapefile.
The .csv file with gridcode and CORINE classes correspondences is provided in the README folder (clc_legend_gridcode.csv)
(if `vectorize = TRUE`).
}
\note{
Examples require large external raster files (hosted on Zenodo)
and depend on external software (Python, GDAL). Therefore, they are wrapped
in dontrun{} to avoid errors during R CMD check and to ensure portability.
}
\examples{
\dontrun{
corine_rasters <- list(
  "corine06" = "data/CORINE_2006.tif"
)

generate_burnable_mask(
  corine_rasters = corine_rasters,
  peninsula_shapefile = "data/peninsula_ib.shp",
  output_raster_dir = "output/rasters",
  output_vector_dir = "output/vectors",
  gdalwarp_path = "C:/ProgramData/anaconda3/Library/bin/gdalwarp.exe",
  python_exe = "C:/ProgramData/anaconda3/python.exe",
  gdal_polygonize_script =
  "C:/ProgramData/anaconda3/Lib/site-packages/osgeo/scripts/gdal_polygonize.py",
  reproject = TRUE,
  res = 90,
  to_wgs84 = TRUE,
  vectorize = TRUE
)
}

}
