% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleDetector.R
\name{sampleDetector}
\alias{sampleDetector}
\title{Subsample Detectors in AcousticStudy}
\usage{
sampleDetector(x, n = 1)
}
\arguments{
\item{x}{\linkS4class{AcousticStudy} object}

\item{n}{if less than 1, proportion of rows to sample from each detector.
If 1 or more, the number of rows to sample from each detector.}
}
\value{
subsampled AcousticStudy \code{x}
}
\description{
samples either a fraction or fixed number from each detector
  in each event of an AcousticStudy
}
\details{
Uses \link[dplyr]{slice_sample} to do the sampling, \code{n}
  is converted either to \code{prop} or \code{n} based on its size.
  Negative values are treated the same as in \link[dplyr]{slice_sample}
}
\examples{

data(exStudy)
nDetections(exStudy)
halfData <- sampleDetector(exStudy, n=0.5)
# there are odd numbers of rows in some detectors, so less than half
nDetections(exStudy)
oneDetPerDetector <- sampleDetector(exStudy, n=1)
nDetections(exStudy)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
