% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgainStart.R
\docType{data}
\name{JANKA}
\alias{JANKA}
\title{Australian Eucalypt Hardwoods}
\format{
A data frame with 36 observations on the following 2 variables: 
\itemize{
\item \code{density} (a measure of density of the timber)
\item \code{hardness} (the Janka hardness of the timber)
}
}
\source{
Williams, E.J. 1959. \emph{Regression Analysis}.  John Wiley & Sons, New York.
}
\usage{
JANKA
}
\description{
The dataset consists of density and hardness measurements from 36 Australian Eucalypt hardwoods.
}
\details{
Janka hardness is a structural property of Australian hardwood timbers. The Janka hardness test measures the force required to imbed a steel ball into a piece of wood.
}
\examples{
ggplot(data = JANKA, aes(x = density, y = hardness)) + geom_point() + geom_smooth()
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}
