% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeGetPartition}
\alias{PCMTreeGetPartition}
\title{Get the starting branch' nodes for each part on a tree}
\usage{
PCMTreeGetPartition(tree)
}
\arguments{
\item{tree}{a phylo object with an edge.part member denoting parts. The
function assumes that each part covers a linked set of branches on the tree.}
}
\value{
a named integer vector with elements equal to the starting nodes for
each part in tree and names equal to the labels of these nodes.
}
\description{
Get the starting branch' nodes for each part on a tree
}
\details{
We call a starting branch the first branch from the root to the tips
of a given part. A starting node is the node at which a starting branch
ends.
}
\examples{
set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
PCMTreeGetPartition(PCMTree(ape::rtree(20)))
}
\seealso{
\code{\link{PCMTreeSetPartition}}
}
