% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDMIFLIN.R
\name{PDMIFLIN}
\alias{PDMIFLIN}
\title{PDMIFLIN}
\usage{
PDMIFLIN(X, Y, Nfactors, Maxit = 100, tol = 0.001)
}
\arguments{
\item{X}{The (NT) times p design matrix, without an intercept where N=number of individuals, T=length of time series, p=number of explanatory variables.}

\item{Y}{The T times N panel of response where N=number of individuals, T=length of time series.}

\item{Nfactors}{A pre-specified number of common factors.}

\item{Maxit}{A maximum number of iterations in optimization. Default is 100.}

\item{tol}{Tolerance level of convergence. Default is 0.001.}
}
\value{
A list with the following components:
\itemize{
\item Coefficients: The estimated heterogeneous coefficients.
\item Lower05: Lower end (5\%) of the 90\% confidence interval of the regression coefficients.
\item Upper95: Upper end (95\%) of the 90\% confidence interval of the regression coefficients.
\item Factors: The estimated common factors across groups.
\item Loadings: The estimated factor loadings for the common factors.
\item Predict: The conditional expectation of response variable.
\item pval: p-value for testing hypothesis on heterogeneous coefficients.
\item Se: Standard error of the estimated regression coefficients.
}
}
\description{
This function estimates heterogeneous panel data models with interactive effects.
This function is similar version of PDMIFLING which accommodates a group structure.
}
\examples{
fit <- PDMIFLIN(data1X,data1Y,2)
}
\references{
Ando, T. and Bai, J. (2015) Asset Pricing with a General Multifactor Structure Journal of Financial Econometrics, 13, 556-604.
}
