% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meantest.clx.R
\name{meantest.clx}
\alias{meantest.clx}
\title{Two-sample high-dimensional mean test (Cai, Liu and Xia, 2014)}
\usage{
meantest.clx(dataX,dataY)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample \eqn{l_\infty}-norm-based
high-dimensional mean test proposed in Cai, Liu and Xia (2014).
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}.
The test statistic is defined as
\deqn{
M_{CLX}=\frac{n_1n_2}{n_1+n_2}\max_{1\leq j\leq p}
 \frac{(\bar{X_j}-\bar{Y_j})^2}
 {\frac{1}{n_1+n_2} [\sum_{u=1}^{n_1} (X_{uj}-\bar{X_j})^2+\sum_{v=1}^{n_2} (Y_{vj}-\bar{Y_j})^2]  }
 }
With some regularity conditions, under the null hypothesis \eqn{H_{0c}: \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the test statistic \eqn{M_{CLX}-2\log p+\log\log p} converges in distribution to
a Gumbel distribution \eqn{G_{mean}(x) = \exp(-\frac{1}{\sqrt{\pi}}\exp(-\frac{x}{2}))}
as \eqn{n_1, n_2, p \rightarrow \infty}.
The asymptotic \eqn{p}-value is obtained by
\deqn{p_{CLX} = 1-G_{mean}(M_{CLX}-2\log p+\log\log p).}
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
meantest.clx(X,Y)
}
\references{
Cai, T. T., Liu, W., and Xia, Y. (2014). Two-sample test of high dimensional
means under dependence. \emph{Journal of the Royal Statistical Society:
Series B: Statistical Methodology}, 76(2):349–372.
}
