% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meantest.cq.R
\name{meantest.cq}
\alias{meantest.cq}
\title{Two-sample high-dimensional mean test (Chen and Qin, 2010)}
\usage{
meantest.cq(dataX,dataY)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample \eqn{l_2}-norm-based high-dimensional
mean test proposed by Chen and Qin (2010).
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}.
The test statistic \eqn{M_{CQ}} is defined as
\deqn{M_{CQ} = \frac{1}{n_1(n_1-1)}\sum_{u\neq v}^{n_1} \mathbf{X}_{u}'\mathbf{X}_{v}
+\frac{1}{n_2(n_2-1)}\sum_{u\neq v}^{n_2} \mathbf{Y}_{u}'\mathbf{Y}_{v}
-\frac{2}{n_1n_2}\sum_u^{n_1}\sum_v^{n_2} \mathbf{X}_{u}'\mathbf{Y}_{v}.}
Under the null hypothesis \eqn{H_{0m}: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2},
the leading variance of \eqn{M_{CQ}} is
\eqn{\sigma^2_{M_{CQ}}=\frac{2}{n_1(n_1-1)}\text{tr}(\mathbf{\Sigma}_1^2)+
\frac{2}{n_2(n_2-1)}\text{tr}(\mathbf{\Sigma}_2^2)+
\frac{4}{n_1n_2}\text{tr}(\mathbf{\Sigma}_1\mathbf{\Sigma}_2)},
which can be consistently estimated by \eqn{\widehat\sigma^2_{M_{CQ}}=
\frac{2}{n_1(n_1-1)}\widehat{\text{tr}(\mathbf{\Sigma}_1^2)}+
\frac{2}{n_2(n_2-1)}\widehat{\text{tr}(\mathbf{\Sigma}_2^2)}+
\frac{4}{n_1n_2}\widehat{\text{tr}(\mathbf{\Sigma}_1\mathbf{\Sigma}_2)}.}
The explicit formulas of \eqn{\widehat{\text{tr}(\mathbf{\Sigma}_1^2)}},
\eqn{\widehat{\text{tr}(\mathbf{\Sigma}_2^2)}}, and
\eqn{\widehat{\text{tr}(\mathbf{\Sigma}_1\mathbf{\Sigma}_2)}}
can be found in Section 3 of Chen and Qin (2010).
With some regularity conditions, under the null hypothesis
\eqn{H_{0m}: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2},
the test statistic \eqn{M_{CQ}} converges in distribution to a standard normal distribution
as \eqn{n_1, n_2, p \rightarrow \infty}.
The asymptotic \eqn{p}-value is obtained by
\deqn{p_{CQ} = 1-\Phi(M_{CQ}/\hat\sigma_{M_{CQ}}),}
where \eqn{\Phi(\cdot)} is the cdf of the standard normal distribution.
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
meantest.cq(X,Y)
}
\references{
Chen, S. X. and Qin, Y. L. (2010). A two-sample test for high-dimensional data
with applications to gene-set testing.
\emph{Annals of Statistics}, 38(2):808–835.
}
