% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pPGaGEV.R
\name{pPGaGEV}
\alias{pPGaGEV}
\title{The cumulative distribution function (CDF) of the power Garima-generalized extreme value distribution(PGaGEV).}
\usage{
pPGaGEV(x, mu, sigma, xi, a, b, c)
}
\arguments{
\item{x}{vector of quantiles.There are three cases as follows:
1) if xi>0, x=[(mu-sigma)/xi,Inf].2) if xi=0, x=[-Inf,Inf].3) if xi<0, x=[-Inf,(mu-sigma)/xi].}

\item{mu}{location parameter.\code{mu}=[-Inf,Inf].}

\item{sigma}{scale parameter number 1. \code{sigma}>0.}

\item{xi}{shape parameter number 1. \code{xi}=[-Inf,Inf].}

\item{a}{scale parameter number 2. \code{a}>0.}

\item{b}{scale parameter number 3. \code{b}>0.}

\item{c}{shape parameter number 2. \code{c}=[-Inf,Inf].}
}
\value{
the CDF of PGaGEV distribution.
}
\description{
This function calculated the CDF of PGaGEV distribution.
}
\details{
The CDF of PGaGEV distribution based on the research paper in references.
}
\examples{
pPGaGEV(1.2,2,1,0.5,0.5,0.5,.5) #xi=0.5
pPGaGEV(1.2,2,1,0.5,0.5,0.5,.5) #xi=0
pPGaGEV(1.2,2,1,0.5,0.5,0.5,.5) #xi=-0.5
x=c(1.2,1.3,1.4)
pPGaGEV(x,2,1,0.5,0.5,0.5,0.5)  #xi=0.5
}
\references{
Kittipong Klinjan, Tipat Sottiwan and Sirinapa Aryuyuen (2024).
Extreme value analysis with new generalized extreme value distributions: a case study for risk analysis on pm2.5 and pm10 in pathum thani, thailand,
Commun. Math. Biol. Neurosci. 2024, 2024:100.DOI:10.28919/cmbn/8833.
}
