% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PKLMtest.R
\name{PKLMtest}
\alias{PKLMtest}
\title{PKLMtest: compute a p-value for testing MCAR}
\usage{
PKLMtest(
  X,
  num.proj = 300,
  num.trees.per.proj = 10,
  nrep = 500,
  min.node.size = 10,
  size.resp.set = 2,
  compute.partial.pvals = FALSE,
  ...
)
}
\arguments{
\item{X}{a numeric matrix containing missing values encoded as NA, the data.}

\item{num.proj}{a positive integer specifying the number of projections to consider for the score.}

\item{num.trees.per.proj}{a positive integer, the number of trees per projection.}

\item{nrep}{a positive integer, the number of permutations.}

\item{min.node.size}{a positive number, the minimum number of nodes in a tree.}

\item{size.resp.set}{an integer (>= 2), maximum number of classes allowed to be compared in each projection.}

\item{compute.partial.pvals}{a boolean, indicate if partial p-values shopuld be computed as well.}

\item{...}{additional parameters.}
}
\value{
a numeric value, the p-value(s) for the MCAR test, the first value is always the global p-value and if compute.partial.pvals is set to TRUE, the next values are the partial p-values for the relative importance of each variable.
}
\description{
PKLMtest: compute a p-value for testing MCAR
}
\examples{
n <- 100
X <- cbind(rnorm(n),rnorm(n))
X.NA <- X
X.NA[,1] <- ifelse(stats::runif(n)<=0.2, NA, X[,1])

pval <- PKLMtest(X.NA, num.proj = 5)

}
