% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreeComp_Volume_Clearance_HalfLife.R
\name{ThreeComp_Volume_Clearance_HalfLife}
\alias{ThreeComp_Volume_Clearance_HalfLife}
\title{Convert pharmacokinetic parameters for three compartment model}
\usage{
ThreeComp_Volume_Clearance_HalfLife(V1,Vd,Cl1,t_alpha,t_beta,t_gamma,
 V1.sd=NA,Vd.sd=NA,Cl1.sd=NA,t_alpha.sd=NA,t_beta.sd=NA,t_gamma.sd=NA,
 covar=c(V1Vd=NA,V1Cl1=NA,V1talpha=NA,V1tbeta=NA,V1tgamma=NA,VdCl1=NA,
   Vdtalpha=NA,Vdtbeta=NA,Vdtgamma=NA,Cl1talpha=NA,Cl1tbeta=NA,
   Cl1tgamma=NA,talphatbeta=NA,talphatgamma=NA,tbetatgamma=NA),...)
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{Vd}{Total volume of distributions}

\item{Cl1}{Clearance from compartment 1}

\item{t_alpha}{half life of compartment 1}

\item{t_beta}{half life of compartment 2}

\item{t_gamma}{half life of compartment 3}

\item{V1.sd}{standard error of V1}

\item{Vd.sd}{standard error of Vd}

\item{Cl1.sd}{standard error of Cl1}

\item{t_alpha.sd}{standard error of t_alpha}

\item{t_beta.sd}{standard error of t_beta}

\item{t_gamma.sd}{standard error of t_gamma}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distributions (Vd and V1),
clearance (Cl1) and half-lives (t_alpha, t_beta, and t_gamma)
}
\examples{
ThreeComp_Volume_Clearance_HalfLife(V1=5,Vd=1110,Cl1=3,
t_alpha=1.142,t_beta=52.2,t_gamma=931, V1.sd=0.01,Vd.sd=20,Cl1.sd=0.01,
t_alpha.sd=0.002,t_beta.sd=0.5,t_gamma.sd=5.6)
}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
