% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiLayerNet_functions.R
\name{plexi_distance_test1_isn}
\alias{plexi_distance_test1_isn}
\title{Test the extremeness of embedding distances of local neighbors.}
\usage{
plexi_distance_test1_isn(distance, p.adjust.method = "none")
}
\arguments{
\item{distance}{a distance list obtained by the \code{plexi_node_distance()} function.}

\item{p.adjust.method}{method for adjusting p-value (including methods on \code{p.adjust.methods}).
If set to "none" (default), no adjustment will be performed.}
}
\value{
The adjusted pvalues for each node.
}
\description{
Test the extremeness of embedding distances of local neighbors.
}
\details{
The adjusted p-values for each node is calculated based on their distance.
}
\examples{
ISN1 = network_gen(n.nodes = 50, n.var.nodes = 5, n.var.nei = 40, noise.sd = .01)
ISN2 = network_gen(n.nodes = 50, n.var.nodes = 5, n.var.nei = 40, noise.sd = .01)
graph_data = cbind(ISN1[["data_graph"]], ISN1[["data_graph"]][,3:4])
embeddingSpaceList = plexi_embedding(graph.data=graph_data, outcome=c(1,2,1,2),
indv.index=c(1,1,2,2), train.rep=2, random.walk=FALSE)
Dist = plexi_node_distance(embeddingSpaceList)
Result = plexi_distance_test1_isn(Dist)

}
