% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_regression.R
\name{phylolm_summary}
\alias{phylolm_summary}
\title{Wrapper for running phylogenetic regression with phylolm\cr}
\usage{
phylolm_summary(y, x, in_tree, model_type = "BM")
}
\arguments{
\item{y}{variable to use for y component of model.}

\item{x}{variable to use for x component of model.}

\item{in_tree}{phylo object. Tip label order is assumed to match the y and x variables.}

\item{model_type}{length-one character vector specifying which phylogenetic model to use (must be a possible setting of the model argument to the phylolm function).}
}
\value{
Numeric vector of length three, providing the estimated coefficients for the intercept and slope, along with the p-value.
}
\description{
Runs basic case of single x and y variables (dummy or continuous). Note that the ordering of the input vectors
and the tree tip labels needs to be checked by the user beforehand:
this script does not require that the y and x variables are named, and so no name check is performed.
}
