% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{kdens}
\alias{kdens}
\title{Kernel density estimator}
\usage{
kdens(x)
}
\arguments{
\item{x}{the data from which the estimate is to be computed.}
}
\value{
a function that approximates the probability density function.
}
\description{
The probability density function \eqn{F'} is estimated using a kernel density
approach. More specifically, first \eqn{y_i = \hat{f}(x_i^\ast)}  is estimated
using \eqn{T = 512} (default for the function \code{\link[stats]{density}})
equally spaced points \eqn{x_i^\ast}, \eqn{1 \leq i \leq T}, in the interval
\eqn{[x_{(1)} - 3b, x_{(n)} + 3b]}, where \eqn{b} is the bandwidth for
the Gaussian kernel density estimator, chosen by applying the Silverman's
rule of thumb (the default procedure in \code{\link[stats]{density}}).
A cubic spline interpolation (the default method for \code{\link[stats]{spline}})
is then applied to the pairs \eqn{\{(x_i^\ast, y_i)\}_{i=1}^T} to obtain
\eqn{\hat F_n'(x)} for all \eqn{x \in [x_{(1)} - 3b, x_{(n)} + 3b]}.
}
\examples{
# creating a time series
trunc = 50000
cks <- arfima.coefs(d = 0.25, trunc = trunc)
eps <- rnorm(trunc+1000)
x <- sapply(1:1000, function(t) sum(cks*rev(eps[t:(t+trunc)])))

# kernel density function
dfun <- kdens(x)

# plot
curve(dfun, from = min(x), to = max(x))

}
