% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenTab4.R
\name{GenTab4}
\alias{GenTab4}
\title{Four-way contingency table r x c x t x u   - generation}
\usage{
GenTab4(pijtu, n)
}
\arguments{
\item{pijtu}{a numeric matrix with non-negative probability values of the four-way contingency table}

\item{n}{a sample size}
}
\value{
The function returns the four-way contingency table r x c x t x u
}
\description{
Generating a four-way contingency table r x c x t x u.
}
\details{
Generating a four-way contingency table r x c x t x u using the probability matrix pijtu.
If Ho is true then pijtu equals 1 / r / c / t / u.
}
\examples{
r = 2; c = 2; t = 2; u = 3
GenTab4(array(1 / (r * c * t * u), dim = c(r, c, t, u)),150)
table = GenTab4(array(1/16, dim = c(2, 2, 2, 2)), 200)
GenTab4(prop.table(table),200)

}
\references{
Extension of the information contained in {Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
