% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms3.test.R
\name{Lms3.test}
\alias{Lms3.test}
\title{Logarithmic minimum test for independence in three-way contingency table}
\usage{
Lms3.test(nijt, B = 10000)
}
\arguments{
\item{nijt}{a numeric matrix with non-negative values of the three-way contingency table cells}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns values of the test statistic and p-value of the logarithmic minimum test.
}
\description{
Calculates the test statistic and p-value of the Logarithmic minimum  test for independence in three-way contingency table
}
\details{
The test statistic and p-value of the Logarithmic minimum  test for independence in r x c x t contingency table,
}
\examples{
\donttest{Lms3.test(GenTab3(array(0.125, dim = c(2, 2, 2)), 80), B = 1e2)}
\donttest{Lms3.test(table4, B = 1e3)}

}
\references{
{Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
