% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod2.cv.R
\name{Mod2.cv}
\alias{Mod2.cv}
\title{Modular test for independence in two-way contingency table}
\usage{
Mod2.cv(nr, nc, n, alfa, B = 10000)
}
\arguments{
\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{n}{a sample size}

\item{alfa}{a significance level}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the critical value of the modular test.
}
\description{
Calculates the critical value of the modular test for independence in two-way contingency table
see formula (9) in the article.
}
\details{
The Critical value of the modular test for independence in r x c contingency table,
see formula (2) in the article.
}
\examples{
\donttest{Mod2.cv(2, 2, 40, 0.05, B = 1e2)}
\donttest{Mod2.cv(2, 3, 60, 0.1)}

}
\references{
{Sulewski, P. (2016). \emph{Moc testów niezależności w tablicy dwudzielczej większej niż 2×2,} Przegląd statystyczny 63(2), 190-210}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
