% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AATP_TPC.R
\name{AATP_TPC}
\alias{AATP_TPC}
\title{AATP_TPC feature vector}
\usage{
AATP_TPC(pssm_name)
}
\arguments{
\item{pssm_name}{is name of PSSM Matrix file}
}
\value{
list of two feature vectors with 400 and 420 dimensions
}
\description{
For getting this features which have been used to protein structural class prediction,
at first mean of every column in PSSM Matrix is computed to achieve a 20-dimensional vector
called AAC.then by combining it with other vector of length 400 called TPC, which is similar to \code{\link{dpc_pssm}}
AATP feature vector of length 420 is obtained.
}
\examples{
X<-AATP_TPC(paste0(system.file("extdata",package="PSSMCOOL"),"/C7GQS7.txt.pssm"))
}
\references{
Zhang, S., Ye, F. and Yuan, X. (2012) Using principal component analysis and support vector machine to predict protein
structural class for low-similarity sequences via PSSM, Journal of Biomolecular Structure & Dynamics, 29, 634-642.
}
\seealso{
\code{\link{dpc_pssm}}
}
