% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpc_pssm.R
\name{LPC_PSSM}
\alias{LPC_PSSM}
\title{Linear predictive coding feature}
\usage{
LPC_PSSM(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 280
}
\description{
This function uses Linear predictive coding algorithm for each column of PSSM Matrix
. so in this script \code{\link[phonTools]{lpc}} function is used which produces a 14-dimensional
vector for each column, since PSSM has 20 column eventually it will be obtained a 20*14=280 dimensional
feature vector for each PSSM Matrix by this function.
}
\examples{
X<-LPC_PSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
L. Li et al., "PSSP-RFE: accurate prediction of protein structural class by recursive feature extraction
from PSI-BLAST profile, physical-chemical property and functional annotations," vol. 9, no. 3, 2014.
}
