% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AADP_PSSM.R
\name{aadp_pssm}
\alias{aadp_pssm}
\title{DPC-PSSM,AAC-PSSM and AADP-PSSM feature vectors}
\usage{
aadp_pssm(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 420
}
\description{
This feature is combination of amino asid composition and dipeptide composition feature
vectors. DPC feature stands for dipeptide composition, to get this feature vector for both different columns
the elements in two consecutive rows corresponds to this columns, would be multiplied and this scenario is done
for all L-1 consecutive rows (L is protein length) and finally summation of these numbers divides by L-1. since
the result depends on two different columns, eventually DPC Feature vector would be of length 400. AAC-PSSM is actually
mean of PSSM Matrix columns which its length is 20. eventually AADP-PSSM is combination of these vectors
and with length 420.
}
\examples{
X<-aadp_pssm(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Liu, T., Zheng, X. and Wang, J. (2010) Prediction of protein structural class for
low-similarity sequences using support vector machine and PSI-BLAST profile, Biochimie, 92, 1330-1334.
}
