% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fas.R
\name{fas}
\alias{fas}
\title{Non-Linear Furusawa and Smith Diffusion Model}
\usage{
fas(t, Ct, m, V, b, Co)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{Ct}{the numerical value for the concentration of the adsorbent at time t}

\item{m}{the numerical value for mass of adsorbent}

\item{V}{the numerical value for volume of solution}

\item{b}{the numerical value for the Langmuir isotherm constant}

\item{Co}{the numerical value for the initial concentration of the adsorbent. If this parameter is not defined, it will be estimated.}
}
\value{
the non-linear regression and the parameter estimation for the Furusawa and Smith Diffusion Model
}
\description{
The Furusawa and Smith Diffusion Model is known to describe the rate of adsorption assuming that only external diffusion resistance was predominant during the initial sorption period and controlled the sorption rate. The diffusion model relates the change in fluid phase concentration and time with the fluid phase concentration at the external surface and an external mass transfer coefficient (Furusawa & Smith, 1974).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
Ct <- c(10.000,8.141,8.056,7.949,7.863,7.799,7.778,7.756,7.692)
m <- 0.05
V <- 0.1
b <- 1.3
Co <- 10
fas(t,Ct,m,V,b,Co)}
}
\references{
Furusawa, T., & Smith, J. M. (1974) <doi:10.1002/aic.690200111> Intraparticle mass transport in slurries by dynamic adsorption studies. AIChE Journal, 20(1), 88–93.

Yakub, E., Agarry, S. E., Omoruwou, F., &; Owabor, C. N. (2020) <doi:10.1080/02726351.2019.1616862> Comparative study of the batch adsorption kinetics and mass transfer in phenol-sand and phenol-clay adsorption systems. Particulate Science and Technology, 38(7), 801-811.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
