% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-Code.R
\name{Code}
\alias{Code}
\title{R6 Code class}
\description{
Class representing a piece of code.
}
\seealso{
Other Representations: 
\code{\link{File}},
\code{\link{Function}},
\code{\link{Repository}}
}
\concept{Representations}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Code-new}{\code{Code$new()}}
\item \href{#method-Code-print}{\code{Code$print()}}
\item \href{#method-Code-getLines}{\code{Code$getLines()}}
\item \href{#method-Code-getNLines}{\code{Code$getNLines()}}
\item \href{#method-Code-getName}{\code{Code$getName()}}
\item \href{#method-Code-clone}{\code{Code$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Code-new"></a>}}
\if{latex}{\out{\hypertarget{method-Code-new}{}}}
\subsection{Method \code{new()}}{
Initializer method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Code$new(name, lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(\code{character(1)})\cr
Name of Code object.}

\item{\code{lines}}{(\code{character(n)})\cr
Vector of lines Code object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Code-print"></a>}}
\if{latex}{\out{\hypertarget{method-Code-print}{}}}
\subsection{Method \code{print()}}{
Overload generic print, to print Code object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Code$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments passed to or from other methods. See \link[base]{print}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{character(n)})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Code-getLines"></a>}}
\if{latex}{\out{\hypertarget{method-Code-getLines}{}}}
\subsection{Method \code{getLines()}}{
Get method for lines.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Code$getLines()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character(n)}) Vector of lines in the Code object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Code-getNLines"></a>}}
\if{latex}{\out{\hypertarget{method-Code-getNLines}{}}}
\subsection{Method \code{getNLines()}}{
Get method for number of lines.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Code$getNLines()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{numeric(1)}) Number of lines in the Code object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Code-getName"></a>}}
\if{latex}{\out{\hypertarget{method-Code-getName}{}}}
\subsection{Method \code{getName()}}{
Get method for Name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Code$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character(1)}) Name of the Code object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Code-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Code-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Code$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
