% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pareto.fit.R
\name{pareto.fit}
\alias{pareto.fit}
\title{Fitting a Pareto distribution}
\usage{
pareto.fit(x, estim.method = "MLE", sigma = NULL, start, ...)
}
\arguments{
\item{x}{The vector of observations.}

\item{estim.method}{The estimation method, "MLE" or "OLS"}

\item{sigma}{The value of the scale parameter, if it is known; if the value is \code{NULL}, the parameter is estimated.}

\item{start}{Unused argument from \code{PPS.fit}.}

\item{\dots}{Other arguments.}
}
\value{
A \code{PPSfit} Object.
}
\description{
It is an auxiliar function for fitting a Pareto distribution as a particular case of a Pareto Positive Stable distribution, allowing the scale parameter to be held fixed if desired.
}
\details{
This function is called by \code{PPS.fit()} when \code{Pareto} argument is \code{TRUE}.
}
\references{
Sarabia, J.M and Prieto, F. (2009). The Pareto-positive stable distribution: A new descriptive model for city size data, \emph{Physica A: Statistical Mechanics and its Applications}, \bold{388}(19), 4179-4191.
}
\seealso{
\code{\link{PPS.fit}}, \code{\link{coef.PPSfit}}, \code{\link{print.PPSfit}}, \code{\link{plot.PPSfit}}, \code{\link{GoF}}
}

