% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/se.R
\name{se}
\alias{print.se}
\alias{se}
\alias{se.default}
\title{Approximated standard errors of Pareto Positive Stable (PPS) parameter estimates}
\usage{
se(PPSfit, k = 2000, parallel = TRUE, ncores = 2, ...)
}
\arguments{
\item{PPSfit}{a \code{PPSfit} Object, typically from \code{PPS.fit()}.}

\item{k}{the number of steps in the bootstrapping procedure.}

\item{parallel}{A logical argument specifying if parallelization is allowed in the bootstrapping procedure.}

\item{ncores}{is the number of cores that we use if parallel is TRUE}

\item{\dots}{other arguments.}
}
\value{
A list with the standard errors.
}
\description{
It approximates the stantard errors of PPS parameter estimates by bootstrapping.
}
\details{
The function simulates \code{k} samples from the model given in the \code{PPSfit} argument, fits them with the same method of estimation and uses the parameter estimates to approximate the standard errors.
}
\examples{
x <- rPPS(50, 1.2, 100, 2.3)
fit <- PPS.fit(x)
coef(fit)
se(fit, k = 50)
}
\references{
Sarabia, J.M and Prieto, F. (2009). The Pareto-positive stable distribution: A new descriptive model for city size data, \emph{Physica A: Statistical Mechanics and its Applications}, \bold{388}(19), 4179-4191.
}
\seealso{
\code{\link{PPS.fit}}
}

