% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.R
\name{reg}
\alias{reg}
\title{Multiple Linear Regression}
\usage{
reg(datap, resp, verbose = FALSE)
}
\arguments{
\item{datap}{The data set}

\item{resp}{an integer value indicating the column in \code{datap} that}

\item{verbose}{If \code{verbose = TRUE} then some results are
printed in the console.
corresponds to the response variable.}
}
\value{
An object of class list
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{reg()} performs a multiple linear regression analysis with extracting the attributed parameters
}
}
\details{
The \code{reg} function fits a multiple linear regression analysis
of one or more independent (exogenous) variables on a dependent(endogenous)
variable in a linear pattern along with testing the significance of
parameters. It is important that according to the type of data may produce some warning errors e.g., for dtsimp as:
Warning message: In summary.lm(mlreg): essentially perfect fit: summary may be unreliable.
This case is due to the intrinsic characteristics of data
}
\examples{
\donttest{
data(dtsimp)
reg(dtsimp, 1, verbose = FALSE)
}
\donttest{
data(heart)
reg(heart, 1, verbose = FALSE)
}
}
\seealso{
\verb{multiple linear regression}
}
\author{
{
Ali Arminian \href{mailto:abeyran@gmail.com}{abeyran@gmail.com}
}
}
\keyword{multiple}
