% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharpeTesting.R
\name{sharpeTesting}
\alias{sharpeTesting}
\title{Testing the difference of Sharpe ratios}
\usage{
sharpeTesting(x, y, control = list())
}
\arguments{
\item{x}{Vector (of length \eqn{T}) of returns for the first fund. \code{NA}
values are allowed.}

\item{y}{Vector (of length \eqn{T}) returns for the second fund. \code{NA}
values are allowed.}

\item{control}{Control parameters (see *Details*).}
}
\value{
A list with the following components:\cr

\code{n}: Number of non-\code{NA} concordant observations.\cr

\code{sharpe}: Vector (of length 2) of unconditional Sharpe ratios.\cr

\code{dsharpe}: Sharpe ratios difference.\cr

\code{tstat}: t-stat of Sharpe ratios differences.\cr

\code{pval}: pvalues of test of Sharpe ratios differences.
}
\description{
Function which performs the testing of the difference of Sharpe ratios.
}
\details{
The Sharpe ratio (Sharpe 1992) is one industry standard for measuring the
absolute risk adjusted performance of hedge funds. This function performs
the testing of Sharpe ratio difference for two funds using the approach by
Ledoit and Wolf (2002).

For the testing, only the intersection of non-\code{NA} observations for the
two funds are used.

The argument \code{control} is a list that can supply any of the following
components:
\itemize{
\item \code{'type'} Asymptotic approach (\code{type = 1}) or
studentized circular bootstrap approach (\code{type = 2}). Default:
\code{type = 1}.
\item \code{'ttype'} Test based on ratio (\code{type = 1})
or product (\code{type = 2}). Default: \code{type = 2}.
\item \code{'hac'} Heteroscedastic-autocorrelation consistent standard
errors. Default: \code{hac = FALSE}.
\item \code{'nBoot'} Number of bootstrap replications for computing the p-value. Default: \code{nBoot =
499}.
\item \code{'bBoot'} Block length in the circular bootstrap. Default:
\code{bBoot = 1}, i.e. iid bootstrap. \code{bBoot = 0} uses optimal
block-length.
\item \code{'pBoot'} Symmetric p-value (\code{pBoot = 1}) or
asymmetric p-value (\code{pBoot = 2}). Default: \code{pBoot = 1}.
}
}
\note{
Further details on the methodology with an application to the hedge
fund industry is given in in Ardia and Boudt (2018).

Some internal functions where adapted from Michael Wolf MATLAB code.
}
\examples{
## Load the data (randomized data of monthly hedge fund returns)
data("hfdata")
x = hfdata[,1]
y = hfdata[,2]

## Run Sharpe testing (asymptotic)
ctr = list(type = 1)
out = sharpeTesting(x, y, control = ctr)
print(out)

## Run Sharpe testing (asymptotic hac)
ctr = list(type = 1, hac = TRUE)
out = sharpeTesting(x, y, control = ctr)
print(out)

## Run Sharpe testing (iid bootstrap)
set.seed(1234)
ctr = list(type = 2, nBoot = 100)
out = sharpeTesting(x, y, control = ctr)
print(out)

## Run Sharpe testing (circular bootstrap)
set.seed(1234)
ctr = list(type = 2, nBoot = 100, bBoot = 5)
out = sharpeTesting(x, y, control = ctr)
print(out)
}
\references{
Ardia, D., Boudt, K. (2015).
Testing equality of modified Sharpe ratios.
\emph{Finance Research Letters} \bold{13}, 97--104.

Ardia, D., Boudt, K. (2018).
The peer performance ratios of hedge funds.
\emph{Journal of Banking and Finance} \bold{87}, 351-.368.

Barras, L., Scaillet, O., Wermers, R. (2010).
False discoveries in mutual fund performance: Measuring luck in estimated alphas.
\emph{Journal of Finance} \bold{65}(1), 179--216.

Sharpe, W.F. (1994).
The Sharpe ratio.
\emph{Journal of Portfolio Management} \bold{21}(1), 49--58.

Ledoit, O., Wolf, M. (2008).
Robust performance hypothesis testing with the Sharpe ratio.
\emph{Journal of Empirical Finance} \bold{15}(5), 850--859.

Storey, J. (2002).
A direct approach to false discovery rates.
\emph{Journal of the Royal Statistical Society B} \bold{64}(3), 479--498.
}
\seealso{
\code{\link{sharpe}}, \code{\link{sharpeScreening}} and
\code{\link{msharpeTesting}}.
}
\author{
David Ardia and Kris Boudt.
}
\keyword{htest}
