% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSpsoContour.R
\name{GetSpsoContour}
\alias{GetSpsoContour}
\title{Assigns next patient cohort based on the SPSOP model with a Utility based objective function.}
\usage{
GetSpsoContour(
  YE,
  YT,
  Doses,
  Dosetried,
  cohort,
  Contour,
  CutE,
  CutT,
  AcceptE,
  AcceptT,
  HypermeansE,
  HypermeansT,
  Hypervars,
  B
)
}
\arguments{
\item{YE}{Length n binary indicator vector of efficacy status.}

\item{YT}{Length n binary indicator vector of toxicity status.}

\item{Doses}{Length n vector of integer Doses given to patients.}

\item{Dosetried}{Binary vector corresponding to which doses have been tried.}

\item{cohort}{Cohort size for the trial.}

\item{Contour}{Contour vector for desirability function. Contains in order: (pi_{1,E},pi_{2,T},pi_{3,E},pi_{4,T}).}

\item{CutE}{Cutoff for efficacy probability acceptability. Dose-efficacy probabilities must be larger than this for patient assignment.}

\item{CutT}{Cutoff for toxicity probability acceptability. Dose-toxicity probabilities must be smaller than this for patient assignment.}

\item{AcceptE}{Posterior probability threshold for efficacy acceptability.}

\item{AcceptT}{Posterior probability threshold for toxicity acceptability.}

\item{HypermeansE}{Hypermeans for dose-specific efficacy parameters.}

\item{HypermeansT}{Hypermeans for dose-specific toxcity parameters.}

\item{Hypervars}{Hypervariances needed for the SPSO model. Contains, in order (sigma_0^2, sigma_mu^2,tau).}

\item{B}{Number of iterations to run for the MCMC.}
}
\value{
A list containing the optimal dose level to assign the next patient cohort in the first entry and a matrix in the second entry, with rows corresponding to (1) the dose #, (2) mean posterior toxicity probability at each dose, mean posterior efficacy probability at each dose, and acceptable posterior desirability score of each dose level (0s indicate the dose is not acceptably efficous or toxic).
}
\description{
Provides the optimal dose level as determined by the SPSO model, posterior mean toxicity probability, efficacy probability, and desirability of each dose level. Doses that are unacceptably toxic or inefficous have a desirability of 0.
}
\examples{
##Get the Data
##True Tox Prob
PT = c(.1,.2,.25,.5,.7)
##True EFF Prob
PE = c(.3,.4,.7,.5,.5)
Doses=c(1,1,1,2,2,2,3,3,3,2,2,2,1,1,1,2,2,2,3,3,3)
YE=Doses
YT=Doses
Dosetried=rep(0,length(PE))
##Generate data
for(k in 1:length(PE)){
if(sum(Doses==k)){
##Dose level has been tried
Dosetried[k]=1
YE[Doses==k]=rbinom(sum(Doses==k),1,PE[k])
YT[Doses==k]=rbinom(sum(Doses==k),1,PT[k])
}
}
##Hyperparameters
HypermeansE=c(-1,-.5,0,.5,1,2)
HypermeansT=HypermeansE
Hypervars=c(1,16,1)
##Trial parameters
cohort=3
##Contour vector
Contour = c(.35, .75,.7,.4)
CutE=.3 ##Efficacy threshold
CutT=.4 ##Toxicity threshold
AcceptE=.3 ##Eff acceptability threshold
AcceptT= .3 ##Tox acceptability threshold
B=100##Number of iterations
GetSpsoContour(YE,YT,Doses,Dosetried,cohort,Contour,CutE, CutT, AcceptE, AcceptT,
HypermeansE,  HypermeansT,Hypervars,B )
}
