% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotypeFunctions.R
\name{getAlleleFrequencies}
\alias{getAlleleFrequencies}
\title{Compute allele frequencies from genotype data.}
\usage{
getAlleleFrequencies(snp)
}
\arguments{
\item{snp}{[N x 1] Vector of length [N] samples with genotypes of a single
bi-allelic genetic variant/SNP encoded as 0,1 and 2.}
}
\value{
Vector with ref (0-encoded) and alt (1-encoded) allele frequencies.
}
\description{
Compute allele frequencies from genotype data.
}
\examples{
# create snp vector with minor allele frequency 0.3
snp <- rbinom(200, 2, 0.3)
allelefreq <- getAlleleFrequencies(snp)
}
