% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variancecomponentFunctions.R
\name{noiseFixedEffects}
\alias{noiseFixedEffects}
\title{Simulate noise fixed effects.}
\usage{
noiseFixedEffects(
  N,
  P,
  NrConfounders = 10,
  sampleID = "ID_",
  phenoID = "Trait_",
  id_samples = NULL,
  id_phenos = NULL,
  pTraitsAffected = 1,
  NrFixedEffects = 1,
  pIndependentConfounders = 0.4,
  pTraitIndependentConfounders = 0.2,
  keepSameIndependent = FALSE,
  distConfounders = "norm",
  mConfounders = 0,
  sdConfounders = 1,
  catConfounders = NULL,
  probConfounders = NULL,
  distBeta = "norm",
  mBeta = 0,
  sdBeta = 1,
  verbose = FALSE
)
}
\arguments{
\item{N}{Number [integer] of samples to simulate.}

\item{P}{Number [integer] of phenotypes to simulate.}

\item{NrConfounders}{Vector of number(s) [integer] of confounders from a 
specified distribution to simulate.}

\item{sampleID}{Prefix [string] for naming samples.}

\item{phenoID}{Prefix [string] for naming traits.}

\item{id_samples}{Vector of [NrSamples] sample IDs [string]; if not provided
constructed by paste(sampleID, 1:N, sep="").}

\item{id_phenos}{Vector of [NrTraits] phenotype IDs [string]; if not provided
constructed by paste(phenoID, 1:P, sep="").}

\item{pTraitsAffected}{Vector of proportion(s) [double] of traits affected by 
the confounders. For non-integer results of pTraitsAffected*P, the ceiling of 
the result is used.}

\item{NrFixedEffects}{Number [integer] of different confounder effects to 
simulate; allows to simulate fixed effects from different distributions or 
with different parameters; if only one type of confounder distribution is 
wanted, set NrFixedEffects=1 and choose the number of confounders with eg 
NrConfounders=10.}

\item{pIndependentConfounders}{Vector of proportion(s) [double] of 
confounders to have a trait-independent effect.}

\item{pTraitIndependentConfounders}{Vector of proportion(s) [double] of 
traits influenced by independent confounder effects.}

\item{keepSameIndependent}{[boolean] If set to TRUE, the independent genetic 
effects always influence the same subset of traits.}

\item{distConfounders}{Vector of name(s) [string] of distribution to use to 
simulate confounders; one of "unif", "norm", "bin", "cat_norm", "cat_unif".}

\item{mConfounders}{Vector of mean/midpoint(s) [double] of normal/uniform 
distribution for confounders.}

\item{sdConfounders}{Vector of standard deviation(s)/distance from 
midpoint(s) [double] of normal/uniform distribution for confounders.}

\item{catConfounders}{Vector of number(s) of confounder categories [integer]; 
required if distConfounders "cat_norm" or "cat_unif".}

\item{probConfounders}{Vector of probability(s) [double] of binomial 
confounders (0/1); required if distConfounders "bin".}

\item{distBeta}{Vector of name(s) [string] of distribution to use to simulate 
effect sizes of confounders; one of "unif" or "norm".}

\item{mBeta}{Vector of mean/midpoint [double] of normal/uniform distribution 
for effect sizes of confounders.}

\item{sdBeta}{Vector of standard deviation/distance from midpoint [double] 
of normal/uniform distribution for effect sizes of confounders.}

\item{verbose}{[boolean] If TRUE, progress info is printed to standard out}
}
\value{
Named list of shared confounder effects (shared: [N x P] matrix), 
independent confoudner effects (independent: [N x P] matrix), 
the confounders labeled as shared or independent effect 
(cov: [NrConfounders x N] matrix) and the simulated effect sizes of the 
confounders (cov_effect: [P x NrConfounders] dataframe).
}
\description{
noiseFixedEffects simulates a number of non-genetic covariate effects 
(confounders). Confounders can have effects across all traits (shared) 
or to a number of traits only (independent); in addition, only a certain 
proportion of traits can be affected by the confounders.
Confounders can be simulated as categorical variables or following a binomial 
, uniform or normal distribution. Effect sizes for the noise effects can be 
simulated from a uniform or normal distribution. Multiple confounder sets 
drawn from different distributions/different parameters of the same 
distribution can be simulated by specifying NrFixedEffects and supplying the 
respective distribution parameters.
}
\examples{
# fixed noise effect with default setting
noiseFE <- noiseFixedEffects(P=5, N=20)

# 1 categorical fixed noise effect with uniform distribution of the 
# categories
noiseFE_catUnif <- noiseFixedEffects(P=10, N=20, NrConfounders=1, 
distConfounders="cat_unif", catConfounders=3)

# 10 fixed noise effect with uniform distribution between 1 and 5 (3 +/- 2) 
# categories
noiseFE_uniformConfounders_normBetas <- noiseFixedEffects(P=10, N=20, 
NrConfounders=10, distConfounders="unif", mConfounders=3, sdConfounders=2, 
distBeta="norm",  sdBeta=2)

 # 4 fixed noise effect with binomial distribution with p=0.2 
noiseFE_binomialConfounders_uniformBetas <- noiseFixedEffects(P=10, N=20, 
NrConfounders=4, distConfounders="bin", probConfounders=0.2, distBeta="norm", 
sdBeta=2)

 # 2 fixed noise effect with 1 binomial confounders and 1 normally 
 # distributed confounder; the latter only affects 2 traits 
 noiseFE_binomialandNormalConfounders <- noiseFixedEffects(P=10, N=20, 
 NrFixedEffects=2, pTraitsAffected =c (1,0.2), NrConfounders=c(2,2), 
 distConfounders=c("bin", "norm"),  probConfounders=0.2)
}
\seealso{
\code{\link{simulateDist}}
}
