% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createphenotypeFunctions.R
\name{rescaleVariance}
\alias{rescaleVariance}
\title{Scale phenotype component.}
\usage{
rescaleVariance(component, propvar)
}
\arguments{
\item{component}{[N x P] Phenotype matrix [double] where [N] are the number 
of samples and P the number of phenotypes}

\item{propvar}{Number [double] specifying the proportion of variance that 
should be explained by this phenotype component}
}
\value{
If propvar != 0, a named list with the [N x P] matrix of the scaled 
component (component) and its scale factor [double] (scale_factor) else 
returns NULL
}
\description{
The function scales the specified component such that the average column 
variance is equal to the user-specified proportion of variance.
}
\examples{
x <- matrix(rnorm(100), nc=10)
x_scaled <- rescaleVariance(x, propvar=0.4)
}
