% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{stat}
\alias{stat}
\title{stat}
\usage{
stat(x, sample = NULL, phe = NULL)
}
\arguments{
\item{x}{Input phenotype data file.}

\item{sample}{The column name of the sample name in phenotypic data. (Default: NULL)}

\item{phe}{The column name of the phenotypic value in data. (Default: NULL)}
}
\value{
Mean, median, standard deviation, standard error of phenotypic data for each sample.
}
\description{
Calculate statistical indicators of phenotypic data
}
\examples{
data("wheatds")
inlier <- outlier(wheatds, sample = "Line", loc = "Env", rep = "Rep", phe = "DS", mode = "blup")
stat_out <- stat(x = inlier, sample = "Sample", phe = "inlier")
}
\author{
Peng Zhao <pengzhao@nwafu.edu.cn>
}
